/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#ifndef WAYLANDBACKEND_WLSHELLINTERFACE
#define WAYLANDBACKEND_WLSHELLINTERFACE 1

#include <errno.h>
#include <string>
#include <wayland-client.h>
#include "WLInterface.hpp"

namespace WaylandBackend
{

class WLShellInterface : public WLInterface
{
public:
    WLShellInterface() { }
    virtual ~WLShellInterface() { }
    
    virtual std::string& getShellName() = 0;
    
    virtual int surfaceCreate(struct wl_surface* wlSurface,
                              unsigned int surfaceId, unsigned int layerId,
                              unsigned int width, unsigned int height)
    {
        return -ENOTSUP;
    }

    virtual int surfaceCreate(struct wl_surface* wlSurface,
                              unsigned int surfaceId, void **shellSurface)
    {
        return -ENOTSUP;
    }

    virtual int surfaceDestroy(void *shellSurface)
    {
        return -ENOTSUP;
    }
    
    virtual int surfaceDestroy(unsigned int surfaceId)
    {
        return -ENOTSUP;
    }
    
    virtual int surfaceSetVisbility(unsigned int surfaceId, void *shellSurface,
                                    bool visible)
    {
        return -ENOTSUP;
    }
                                
    virtual int surfaceConfigure(unsigned int surfaceId, void *shellSurface,
                                 int x, int y, unsigned int width,
                                 unsigned int height)
    {
        return -ENOTSUP;
    }

    virtual int surfaceConfigureSynchronous(unsigned int surfaceId,
                                            void *shellSurface, int x, int y,
                                            unsigned int width,
                                            unsigned int height)
    {
        return -ENOTSUP;
    }
    
    
    virtual int surfaceSetTitle(void* shellSurface, const char *title)
    {
        return -ENOTSUP;
    }
    
    virtual int surfaceSetClass(void* shellSurface, const char *surfClass)
    {
        return -ENOTSUP;
    }
    
    virtual int surfaceSetAsPopup(void* shellSurface, struct wl_seat *seat,
                                   uint32_t serial, struct wl_surface *parent,
                                   int32_t x, int32_t y, uint32_t flags)
    {
        return -ENOTSUP;
    }
    
    virtual int surfaceSetMaximized(void* shellSurface, struct wl_output *output)
    {
        return -ENOTSUP;
    }

    virtual int surfaceSetFullScreen(void *shellSurface, uint32_t method,
                                     uint32_t framerate, struct wl_output *output)
    {
        return -ENOTSUP;
    }
    
    virtual int surfaceSetTransient(void *shellSurface, struct wl_surface *parent,
                                    int32_t x, int32_t y, uint32_t flags)
    {
        return -ENOTSUP;
    }

    virtual int surfaceSetTopLevel(void *shellSurface)
    {
        return -ENOTSUP;
    }
    
    virtual int surfaceResize(void *shellSurface, struct wl_seat *seat,
                              uint32_t serial, uint32_t edges)
    {
        return -ENOTSUP;
    }

    virtual int surfaceMove(void *shellSurface, struct wl_seat *seat, uint32_t serial)
    {
        return -ENOTSUP;
    }
};

}

#endif
